
# Example to publish an R model in the Azure Cloud ..
# for Global Azure Bootcamp 
# by Mario Schnalzenberger (cubido)



install.packages("gbm") 
library(MASS) 
library(gbm) 

test <- Boston[22:27, 1:13] 
set.seed(123) 
gbm1 <- gbm(medv ~ ., 
            distribution = "gaussian", 
            n.trees = 5000, 
            interaction.depth = 8, 
            n.minobsinnode = 1, 
            shrinkage = 0.01, 
            cv.folds = 5, 
            data = Boston) 

best.iter <- gbm.perf(gbm1, method="cv", plot=FALSE) 


mypredict <- function(newdata) { 
    require(gbm) 
    predict(gbm1, newdata, best.iter) 
    } # Example use of the prediction function 


print(mypredict(test))




library(AzureML)


myWs <- workspace(id = "Workspace Id (see Settingstab in Azure Portal)",
                  auth = "Auth Key  (see Settingstab in Azure Portal)",
                  api_endpoint = "https://europewest.studio.azureml.net",
                  management_endpoint = "https://europewest.management.azureml.net")


ep <- publishWebService(ws = myWs, fun = mypredict, name = "analyticslab-gbm",inputSchema = test)

print(consume(ep, test))


mypredict(test)


deleteWebService(myWs, name = "analyticslab-gbm")





